package gov.va.genisis2.exceptions;

import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import gov.va.genisis2.AbstractMockMvcTests;

/**
 * 
 * @author1 Janet Lopez
 * 
 * The Class ErrorResponseTest.
 * 
 * Description: In this ErrorResponseTest Class which extends the abstract
 * class, AbstractMockMvcTests, junit tests are defined.
 * 
 */
public class ErrorResponseTest extends AbstractMockMvcTests {
	
	/** The LOGGER. */
	private static final Logger LOGGER = LoggerFactory.getLogger(ErrorResponseTest.class);

	/**
	 * Test error response.
	 */
	@Test
	public void TestErrorResponse() {

		LOGGER.info("**********Junit Test Error Response**********");

		ErrorResponse errorResponse = new ErrorResponse();
		Assert.assertEquals(0, errorResponse.getErrorCode());
		Assert.assertNull(errorResponse.getMessage());

		errorResponse.setErrorCode(1);
		errorResponse.setMessage("messageTestOne");

		Assert.assertEquals(1, errorResponse.getErrorCode());
		Assert.assertEquals("messageTestOne", errorResponse.getMessage());

		LOGGER.info("**********Junit Test Error Response**********");
	}

}
